/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.filter;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mekanism.common.Mekanism;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.list.SyncableFilterList;
import mekanism.common.lib.collection.HashList;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import org.jetbrains.annotations.Nullable;

public class FilterManager<FILTER extends IFilter<?>> {
    private final Class<? extends FILTER> filterClass;
    protected final Runnable markForSave;
    protected HashList<FILTER> filters = new HashList();
    @Nullable
    protected List<FILTER> enabledFilters = null;

    public FilterManager(Class<? extends FILTER> filterClass, Runnable markForSave) {
        this.filterClass = filterClass;
        this.markForSave = markForSave;
    }

    public final HashList<FILTER> getFilters() {
        return this.filters;
    }

    public final List<FILTER> getEnabledFilters() {
        if (this.enabledFilters == null) {
            this.enabledFilters = this.filters.stream().filter(IFilter::isEnabled).collect(Collectors.toList());
        }
        return this.enabledFilters;
    }

    public final int count() {
        return this.filters.size();
    }

    public boolean anyEnabledMatch(Predicate<FILTER> validator) {
        for (IFilter filter : this.getEnabledFilters()) {
            if (!validator.test(filter)) continue;
            return true;
        }
        return false;
    }

    public <DATA> boolean anyEnabledMatch(DATA extra, BiPredicate<FILTER, DATA> validator) {
        for (IFilter filter : this.getEnabledFilters()) {
            if (!validator.test(filter, extra)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnabledFilters() {
        return !this.getEnabledFilters().isEmpty();
    }

    public void toggleState(int index) {
        IFilter filter = (IFilter)this.filters.getOrNull(index);
        if (filter != null) {
            filter.setEnabled(!filter.isEnabled());
            this.markForSave.run();
            this.enabledFilters = null;
        }
    }

    public void trySetFilters(Collection<IFilter<?>> filters) {
        this.filters.clear();
        this.enabledFilters = new ArrayList<FILTER>();
        for (IFilter<?> filter : filters) {
            this.tryAddFilter(filter, false);
        }
        this.markForSave.run();
    }

    public void tryAddFilter(IFilter<?> toAdd, boolean save) {
        if (this.filterClass.isInstance(toAdd)) {
            this.addFilter((IFilter)this.filterClass.cast(toAdd), save);
        }
    }

    public boolean addFilter(FILTER filter) {
        return this.addFilter(filter, true);
    }

    private boolean addFilter(FILTER filter, boolean save) {
        boolean result = this.filters.add(filter);
        if (save) {
            this.markForSave.run();
        }
        if (this.enabledFilters != null && filter.isEnabled()) {
            this.enabledFilters.add(filter);
        }
        return result;
    }

    public boolean removeFilter(FILTER filter) {
        boolean result = this.filters.remove(filter);
        this.markForSave.run();
        if (filter.isEnabled()) {
            this.enabledFilters = null;
        }
        return result;
    }

    public <F extends IFilter<F>> void tryEditFilter(F currentFilter, @Nullable F newFilter) {
        if (this.filterClass.isInstance(currentFilter)) {
            if (newFilter == null) {
                this.removeFilter((IFilter)this.filterClass.cast(currentFilter));
            } else {
                this.editFilter((IFilter)this.filterClass.cast(currentFilter), (IFilter)this.filterClass.cast(newFilter));
            }
        }
    }

    private void editFilter(FILTER currentFilter, FILTER newFilter) {
        if (this.filters.replace(currentFilter, newFilter)) {
            this.markForSave.run();
            if (currentFilter.isEnabled() || newFilter.isEnabled()) {
                this.enabledFilters = null;
            }
        }
    }

    public void addContainerTrackers(MekanismContainer container) {
        container.track(SyncableFilterList.create(this::getFilters, value -> {
            HashList filterList;
            this.filters = value instanceof HashList ? (filterList = (HashList)value) : new HashList(value);
            this.enabledFilters = null;
        }));
    }

    public void writeToNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        if (!this.filters.isEmpty()) {
            ListTag filterTags = new ListTag();
            RegistryOps serializationContext = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            for (IFilter filter : this.filters) {
                DataResult encoded = BaseFilter.GENERIC_CODEC.encodeStart((DynamicOps)serializationContext, (Object)filter);
                encoded.ifSuccess(arg_0 -> filterTags.add(arg_0));
                encoded.ifError(error -> Mekanism.logger.warn("Failed to serialize filter: {}", (Object)error.message()));
            }
            if (!filterTags.isEmpty()) {
                nbt.put("filters", (Tag)filterTags);
            }
        }
    }

    public void readFromNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.filters.clear();
        this.enabledFilters = new ArrayList<FILTER>();
        NBTUtils.setListIfPresent(nbt, "filters", 10, tagList -> {
            RegistryOps serializationContext = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            int size = tagList.size();
            for (int i = 0; i < size; ++i) {
                DataResult decoded = BaseFilter.GENERIC_CODEC.parse((DynamicOps)serializationContext, (Object)tagList.getCompound(i));
                if (decoded.isSuccess()) {
                    this.tryAddFilter((IFilter)decoded.getOrThrow(), false);
                    continue;
                }
                decoded.ifError(error -> Mekanism.logger.warn("Failed to deserialize stored filter: {}", (Object)error.message()));
            }
        });
    }
}

