/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import mekanism.common.Mekanism;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class AttributeHasBounding
implements Attribute {
    public static final AttributeHasBounding ABOVE_ONLY = new AttributeHasBounding(new HandleBoundingBlock(){

        @Override
        public <DATA> boolean handle(Level level, BlockPos pos, BlockState state, DATA data, TriBooleanFunction<Level, BlockPos, DATA> consumer) {
            return consumer.accept(level, pos.above(), data);
        }
    });
    private final HandleBoundingBlock boundingPosHandlers;

    public AttributeHasBounding(HandleBoundingBlock boundingPosHandlers) {
        this.boundingPosHandlers = boundingPosHandlers;
    }

    public void removeBoundingBlocks(Level world, BlockPos pos, BlockState state) {
        this.boundingPosHandlers.handle(world, pos, state, null, (level, p, ignored) -> {
            BlockState boundingState = level.getBlockState(p);
            if (!boundingState.isAir()) {
                if (boundingState.is(MekanismBlocks.BOUNDING_BLOCK)) {
                    level.removeBlock(p, false);
                } else {
                    Mekanism.logger.warn("Skipping removing block, expected bounding block but the block at {} in {} was {}", new Object[]{p, level.dimension().location(), boundingState.getBlockHolder().getRegisteredName()});
                }
            }
            return true;
        });
    }

    public void placeBoundingBlocks(Level world, BlockPos orig, BlockState state) {
        this.boundingPosHandlers.handle(world, orig, state, orig, (level, boundingLocation, data) -> {
            BlockState newState = BlockStateHelper.getStateForPlacement(MekanismBlocks.BOUNDING_BLOCK.defaultState(), (LevelAccessor)level, boundingLocation, null, Direction.NORTH);
            level.setBlock(boundingLocation, newState, 3);
            if (!level.isClientSide()) {
                TileEntityBoundingBlock tile = WorldUtils.getTileEntity(TileEntityBoundingBlock.class, (BlockGetter)level, boundingLocation);
                if (tile != null) {
                    tile.setMainLocation((BlockPos)data);
                } else {
                    Mekanism.logger.warn("Unable to find Bounding Block Tile at: {}", boundingLocation);
                }
            }
            return true;
        });
    }

    public <DATA> boolean handle(Level level, BlockPos pos, BlockState state, DATA data, TriBooleanFunction<Level, BlockPos, DATA> predicate) {
        return this.boundingPosHandlers.handle(level, pos, state, data, predicate);
    }

    public static interface HandleBoundingBlock {
        public <DATA> boolean handle(Level var1, BlockPos var2, BlockState var3, DATA var4, TriBooleanFunction<Level, BlockPos, DATA> var5);
    }

    @FunctionalInterface
    public static interface TriBooleanFunction<PARAM1, PARAM2, PARAM3> {
        public boolean accept(PARAM1 var1, PARAM2 var2, PARAM3 var3);
    }
}

