/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.data;

import java.util.Objects;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.render.data.ChemicalRenderData;
import mekanism.client.render.data.FluidRenderData;
import mekanism.common.lib.multiblock.MultiblockData;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class RenderData {
    public final BlockPos location;
    public final int height;
    public final int length;
    public final int width;

    protected RenderData(BlockPos renderLocation, int width, int height, int length) {
        this.location = renderLocation;
        this.width = width;
        this.height = height;
        this.length = length;
    }

    public abstract TextureAtlasSprite getTexture();

    public abstract boolean isGaseous();

    public abstract int getColorARGB(float var1);

    public int calculateGlowLight(int light) {
        return light;
    }

    public int hashCode() {
        return Objects.hash(this.height, this.length, this.width);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof RenderData)) return false;
        RenderData data = (RenderData)object;
        if (data.height != this.height) return false;
        if (data.length != this.length) return false;
        if (data.width != this.width) return false;
        return true;
    }

    public static class Builder<DATA_TYPE extends RenderData> {
        private final Holder<Chemical> chemical;
        private final FluidStack fluid;
        @Nullable
        private BlockPos location;
        private int height;
        private int length;
        private int width;

        private Builder(Holder<Chemical> chemical, FluidStack fluid) {
            this.chemical = chemical;
            this.fluid = fluid;
        }

        public static Builder<ChemicalRenderData> create(ChemicalStack chemical) {
            if (chemical.isEmpty()) {
                throw new IllegalArgumentException("Chemical may not be empty");
            }
            return new Builder<ChemicalRenderData>(chemical.getChemicalHolder(), FluidStack.EMPTY);
        }

        public static Builder<FluidRenderData> create(FluidStack fluid) {
            if (fluid.isEmpty()) {
                throw new IllegalArgumentException("Fluid may not be empty");
            }
            return new Builder<FluidRenderData>(MekanismAPI.EMPTY_CHEMICAL_HOLDER, fluid);
        }

        public Builder<DATA_TYPE> location(BlockPos renderLocation) {
            this.location = renderLocation;
            return this;
        }

        public Builder<DATA_TYPE> height(int height) {
            this.height = height;
            return this;
        }

        public Builder<DATA_TYPE> length(int length) {
            this.length = length;
            return this;
        }

        public Builder<DATA_TYPE> width(int width) {
            this.width = width;
            return this;
        }

        public Builder<DATA_TYPE> dimensions(int width, int height, int length) {
            return this.width(width).height(height).length(length);
        }

        public Builder<DATA_TYPE> of(MultiblockData multiblock) {
            return this.location(Objects.requireNonNull(multiblock.renderLocation, "Render location may not be null.").offset(1, 0, 1)).dimensions(multiblock.width() - 2, multiblock.height() - 2, multiblock.length() - 2);
        }

        public DATA_TYPE build() {
            RenderData data;
            if (this.location == null) {
                throw new IllegalStateException("Incomplete render data builder, no render location set.");
            }
            if (!this.fluid.isEmpty()) {
                data = new FluidRenderData(this.location, this.width, this.height, this.length, this.fluid);
            } else if (!this.chemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
                data = new ChemicalRenderData(this.location, this.width, this.height, this.length, this.chemical);
            } else {
                throw new IllegalStateException("Incomplete render data builder, missing or unknown chemical or fluid.");
            }
            return (DATA_TYPE)data;
        }
    }
}

