/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Predicate;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.text.ILangEntry;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.hud.MekanismHUD;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.HUDElement;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.gear.ItemMekaTool;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class HUDRenderer {
    private static final EquipmentSlot[] EQUIPMENT_ORDER = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND};
    private static final ResourceLocation[] ARMOR_ICONS = new ResourceLocation[]{MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_helmet.png"), MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_chest.png"), MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_leggings.png"), MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekasuit_boots.png")};
    private static final ResourceLocation TOOL_ICON = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "hud_mekatool.png");
    private static final ResourceLocation COMPASS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "compass.png");
    private long lastTick = -1L;
    private float prevRotationYaw;
    private float prevRotationPitch;

    public void renderHUD(Minecraft minecraft, GuiGraphics guiGraphics, Font font, List<MekanismHUD.DelayedString> delayedDraws, DeltaTracker delta, int screenWidth, int screenHeight, int maxTextHeight, boolean reverseHud) {
        LocalPlayer player = minecraft.player;
        this.update((Level)minecraft.level, (Player)player);
        if (MekanismConfig.client.hudOpacity.get() < 0.05f) {
            return;
        }
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        float yawJitter = -HUDRenderer.absSqrt(player.yHeadRot - this.prevRotationYaw);
        float pitchJitter = -HUDRenderer.absSqrt(player.getXRot() - this.prevRotationPitch);
        pose.translate(yawJitter, pitchJitter, 0.0f);
        if (MekanismConfig.client.hudCompassEnabled.get()) {
            this.renderCompass((Player)player, font, guiGraphics, delayedDraws, delta, screenWidth, screenHeight, maxTextHeight, reverseHud);
        }
        this.renderMekaSuitEnergyIcons((Player)player, font, guiGraphics, delayedDraws);
        this.renderMekaSuitModuleIcons((Player)player, font, guiGraphics, delayedDraws, screenWidth, screenHeight, reverseHud);
        pose.popPose();
    }

    private void update(Level level, Player player) {
        if (this.lastTick == -1L || level.getGameTime() - this.lastTick > 1L || !level.tickRateManager().runsNormally()) {
            this.prevRotationYaw = player.getYRot();
            this.prevRotationPitch = player.getXRot();
        }
        this.lastTick = level.getGameTime();
        float yawDiff = player.yHeadRot - this.prevRotationYaw;
        float pitchDiff = player.getXRot() - this.prevRotationPitch;
        float jitter = MekanismConfig.client.hudJitter.get();
        this.prevRotationYaw += yawDiff / jitter;
        this.prevRotationPitch += pitchDiff / jitter;
    }

    private static float absSqrt(float val) {
        float ret = Mth.sqrt((float)Math.abs(val));
        return val < 0.0f ? -ret : ret;
    }

    private void renderMekaSuitEnergyIcons(Player player, Font font, GuiGraphics guiGraphics, List<MekanismHUD.DelayedString> delayedDraws) {
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate(10.0f, 10.0f, 0.0f);
        Matrix4f matrix = new Matrix4f((Matrix4fc)pose.last().pose());
        int posX = 0;
        Predicate<Item> showArmorPercent = item -> item instanceof ItemMekaSuitArmor;
        for (int i = 0; i < EnumUtils.ARMOR_SLOTS.length; ++i) {
            posX += this.renderEnergyIcon(player, font, guiGraphics, matrix, delayedDraws, posX, ARMOR_ICONS[i], EnumUtils.ARMOR_SLOTS[i], showArmorPercent);
        }
        Predicate<Item> showToolPercent = item -> item instanceof ItemMekaTool;
        for (EquipmentSlot hand : EnumUtils.HAND_SLOTS) {
            posX += this.renderEnergyIcon(player, font, guiGraphics, matrix, delayedDraws, posX, TOOL_ICON, hand, showToolPercent);
        }
        pose.popPose();
    }

    private int renderEnergyIcon(Player player, Font font, GuiGraphics guiGraphics, Matrix4f matrix, List<MekanismHUD.DelayedString> delayedDraws, int posX, ResourceLocation icon, EquipmentSlot slot, Predicate<Item> showPercent) {
        ItemStack stack = player.getItemBySlot(slot);
        if (showPercent.test(stack.getItem())) {
            this.renderHUDElement(font, guiGraphics, matrix, delayedDraws, posX, 0, IModuleHelper.INSTANCE.hudElementPercent(icon, StorageUtils.getEnergyRatio(stack)), false);
            return 48;
        }
        return 0;
    }

    private void renderMekaSuitModuleIcons(Player player, Font font, GuiGraphics guiGraphics, List<MekanismHUD.DelayedString> delayedDraws, int screenWidth, int screenHeight, boolean reverseHud) {
        int startX = screenWidth - 10;
        int curY = screenHeight - 10;
        Matrix4f matrix = new Matrix4f((Matrix4fc)guiGraphics.pose().last().pose());
        for (EquipmentSlot type : EQUIPMENT_ORDER) {
            ItemStack stack = player.getItemBySlot(type);
            IModuleContainer moduleContainer = IModuleHelper.INSTANCE.getModuleContainer(stack);
            if (moduleContainer == null) continue;
            for (IHUDElement element : moduleContainer.getHUDElements(player, stack)) {
                curY -= 18;
                if (reverseHud) {
                    this.renderHUDElement(font, guiGraphics, matrix, delayedDraws, 10, curY, element, false);
                    continue;
                }
                int elementWidth = 24 + font.width((FormattedText)element.getText());
                this.renderHUDElement(font, guiGraphics, matrix, delayedDraws, startX - elementWidth, curY, element, true);
            }
        }
    }

    private void renderHUDElement(Font font, GuiGraphics guiGraphics, Matrix4f matrix, List<MekanismHUD.DelayedString> delayedDraws, int x, int y, IHUDElement element, boolean iconRight) {
        int color = element.getColor();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        MekanismRenderer.color(guiGraphics, color);
        guiGraphics.blit(element.getIcon(), iconRight ? x + font.width((FormattedText)element.getText()) + 2 : x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        MekanismRenderer.resetColor(guiGraphics);
        delayedDraws.add(new MekanismHUD.DelayedString(matrix, element.getText(), iconRight ? (float)x : (float)(x + 18), (float)(y + 5), color, false));
    }

    private void renderCompass(Player player, Font font, GuiGraphics guiGraphics, List<MekanismHUD.DelayedString> delayedDraws, DeltaTracker delta, int screenWidth, int screenHeight, int maxTextHeight, boolean reverseHud) {
        int color = HUDElement.HUDColor.REGULAR.getColorARGB();
        int posX = reverseHud ? screenWidth - 125 : 25;
        int posY = Math.min(screenHeight - 20, maxTextHeight) - 80;
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)(posX + 50), (float)(posY + 50), 0.0f);
        pose.pushPose();
        pose.pushPose();
        pose.scale(0.7f, 0.7f, 0.7f);
        MutableComponent coords = MekanismLang.GENERIC_BLOCK_POS.translate(player.getBlockX(), player.getBlockY(), player.getBlockZ());
        delayedDraws.add(new MekanismHUD.DelayedString(pose, (Component)coords, (float)(-font.width((FormattedText)coords)) / 2.0f, -4.0f, color, false));
        pose.popPose();
        float angle = 180.0f - player.getViewYRot(delta.getGameTimeDeltaPartialTick(false));
        pose.mulPose(Axis.XP.rotationDegrees(-60.0f));
        pose.mulPose(Axis.ZP.rotationDegrees(angle));
        this.rotateStr(guiGraphics, delayedDraws, MekanismLang.NORTH_SHORT, angle, 0.0f, color);
        this.rotateStr(guiGraphics, delayedDraws, MekanismLang.EAST_SHORT, angle, 90.0f, color);
        this.rotateStr(guiGraphics, delayedDraws, MekanismLang.SOUTH_SHORT, angle, 180.0f, color);
        this.rotateStr(guiGraphics, delayedDraws, MekanismLang.WEST_SHORT, angle, 270.0f, color);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        MekanismRenderer.color(guiGraphics, color);
        guiGraphics.blit(COMPASS, -50, -50, 100, 100, 0.0f, 0.0f, 256, 256, 256, 256);
        MekanismRenderer.resetColor(guiGraphics);
        pose.popPose();
        pose.popPose();
    }

    private void rotateStr(GuiGraphics guiGraphics, List<MekanismHUD.DelayedString> delayedDraws, ILangEntry langEntry, float rotation, float shift, int color) {
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.mulPose(Axis.ZP.rotationDegrees(shift));
        pose.translate(0.0f, -50.0f, 0.0f);
        pose.mulPose(Axis.ZP.rotationDegrees(-rotation - shift));
        delayedDraws.add(new MekanismHUD.DelayedString(pose, (Component)langEntry.translate(), -2.5f, -4.0f, color, false));
        pose.popPose();
    }
}

