/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.GuiUtils;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.util.text.TextUtils;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class ChemicalStackRenderer
implements IIngredientRenderer<ChemicalStack> {
    private static final int TEXTURE_SIZE = 16;
    private static final int MIN_CHEMICAL_HEIGHT = 1;
    private final long capacityMb;
    private final TooltipMode tooltipMode;
    private final int width;
    private final int height;

    public ChemicalStackRenderer() {
        this(1000L, TooltipMode.ITEM_LIST, 16, 16);
    }

    public ChemicalStackRenderer(long capacityMb, int width, int height) {
        this(capacityMb, TooltipMode.SHOW_AMOUNT, width, height);
    }

    private ChemicalStackRenderer(long capacityMb, TooltipMode tooltipMode, int width, int height) {
        Preconditions.checkArgument((capacityMb > 0L ? 1 : 0) != 0, (Object)"capacity must be > 0");
        this.capacityMb = capacityMb;
        this.tooltipMode = tooltipMode;
        this.width = width;
        this.height = height;
    }

    public void render(@NotNull GuiGraphics guiGraphics, ChemicalStack stack) {
        if (!stack.isEmpty()) {
            int desiredHeight = MathUtils.clampToInt((double)this.height * (double)stack.getAmount() / (double)this.capacityMb);
            if (desiredHeight < 1) {
                desiredHeight = 1;
            }
            if (desiredHeight > this.height) {
                desiredHeight = this.height;
            }
            MekanismRenderer.color(guiGraphics, stack);
            GuiUtils.drawTiledSprite(guiGraphics, 0, 0, this.height, this.width, desiredHeight, MekanismRenderer.getChemicalTexture(stack), 16, 16, 100, GuiUtils.TilingDirection.UP_RIGHT);
            MekanismRenderer.resetColor(guiGraphics);
        }
    }

    @Deprecated(forRemoval=true, since="19.5.4")
    public List<Component> getTooltip(ChemicalStack stack, TooltipFlag tooltipFlag) {
        Holder<Chemical> chemical = stack.getChemicalHolder();
        if (chemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
            return Collections.emptyList();
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        this.collectTooltips(stack, tooltips, tooltipFlag);
        return tooltips;
    }

    public void getTooltip(ITooltipBuilder builder, ChemicalStack stack, TooltipFlag tooltipFlag) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        this.collectTooltips(stack, tooltips, tooltipFlag);
        builder.addAll(tooltips);
    }

    private void collectTooltips(ChemicalStack stack, List<Component> tooltips, TooltipFlag tooltipFlag) {
        Holder<Chemical> chemical = stack.getChemicalHolder();
        if (!chemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
            tooltips.add((Component)TextComponentUtil.build(chemical));
            if (this.tooltipMode == TooltipMode.SHOW_AMOUNT_AND_CAPACITY) {
                tooltips.add((Component)MekanismLang.JEI_AMOUNT_WITH_CAPACITY.translateColored(EnumColor.GRAY, TextUtils.format(stack.getAmount()), TextUtils.format(this.capacityMb)));
            } else if (this.tooltipMode == TooltipMode.SHOW_AMOUNT) {
                tooltips.add((Component)MekanismLang.GENERIC_MB.translateColored(EnumColor.GRAY, TextUtils.format(stack.getAmount())));
            }
            stack.appendHoverText(RecipeViewerUtils.getRVTooltipContext(), tooltips, tooltipFlag);
        }
    }

    public Font getFontRenderer(Minecraft minecraft, ChemicalStack stack) {
        return minecraft.font;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    static enum TooltipMode {
        SHOW_AMOUNT,
        SHOW_AMOUNT_AND_CAPACITY,
        ITEM_LIST;

    }
}

