/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mekanism.api.MekanismAPITags;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.datamaps.IMekanismDataMapTypes;
import mekanism.api.datamaps.chemical.ChemicalSolidTag;
import mekanism.api.recipes.ItemStackToChemicalRecipe;
import mekanism.api.recipes.basic.BasicItemStackToFluidOptionalItemRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.client.MekanismClient;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.progress.IProgressInfoHandler;
import mekanism.common.MekanismLang;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.tile.machine.TileEntityNutritionalLiquifier;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RecipeViewerUtils {
    public static final IProgressInfoHandler CONSTANT_PROGRESS = () -> 1.0;
    public static final GuiBar.IBarInfoHandler FULL_BAR = () -> 1.0;

    private RecipeViewerUtils() {
    }

    public static IProgressInfoHandler progressHandler(int processTime) {
        int time = 50 * processTime;
        return () -> {
            double subTime = System.currentTimeMillis() % (long)time;
            return subTime / (double)time;
        };
    }

    public static GuiBar.IBarInfoHandler barProgressHandler(int processTime) {
        MutableComponent tooltip = MekanismLang.TICKS_REQUIRED.translate(processTime);
        int time = 50 * processTime;
        return new GuiBar.IBarInfoHandler(){
            final /* synthetic */ Component val$tooltip;
            final /* synthetic */ int val$time;
            {
                this.val$tooltip = component;
                this.val$time = n;
            }

            @Override
            public Component getTooltip() {
                return this.val$tooltip;
            }

            @Override
            public double getLevel() {
                double subTime = System.currentTimeMillis() % (long)this.val$time;
                return subTime / (double)this.val$time;
            }
        };
    }

    public static ResourceLocation synthetic(ResourceLocation id, String prefix, String namespace) {
        return RecipeViewerUtils.synthetic(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)id.toString().replace(':', '_')), prefix);
    }

    public static ResourceLocation synthetic(String id, String prefix, String namespace) {
        if (id.equals("[unregistered]")) {
            return RecipeViewerUtils.synthetic(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"_unregistered_sad_face_"), prefix);
        }
        return RecipeViewerUtils.synthetic(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)id.replace(':', '_')), prefix);
    }

    public static ResourceLocation synthetic(ResourceLocation id, String prefix) {
        return id.withPrefix("/" + prefix + "/");
    }

    public static <T> T getCurrent(List<T> elements) {
        return elements.get(RecipeViewerUtils.getIndex(elements));
    }

    public static int getIndex(List<?> elements) {
        return (int)(System.currentTimeMillis() / TimeUtil.MILLISECONDS_PER_SECOND % (long)elements.size());
    }

    public static long getCurrent(long[] elements) {
        return elements[RecipeViewerUtils.getIndex(elements)];
    }

    public static <T> int getIndex(long[] elements) {
        return (int)(System.currentTimeMillis() / TimeUtil.MILLISECONDS_PER_SECOND % (long)elements.length);
    }

    public static List<ItemStack> getStacksFor(ChemicalStackIngredient ingredient, boolean displayConversions) {
        Set<Holder<Chemical>> chemicals = ingredient.getRepresentations().stream().map(ChemicalStack::getChemicalHolder).collect(Collectors.toSet());
        return RecipeViewerUtils.getStacksFor(chemicals, displayConversions ? MekanismRecipeType.CHEMICAL_CONVERSION : null);
    }

    private static List<ItemStack> getStacksFor(Set<Holder<Chemical>> supportedTypes, @Nullable IMekanismRecipeTypeProvider<?, ? extends ItemStackToChemicalRecipe, ?> recipeType) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Holder<Chemical> holder : supportedTypes) {
            stacks.add(ChemicalUtil.getFullChemicalTank(ChemicalTankTier.BASIC, holder));
        }
        if (recipeType != null) {
            block1: for (RecipeHolder recipeHolder : recipeType.getRecipes(null)) {
                ItemStackToChemicalRecipe recipe = (ItemStackToChemicalRecipe)recipeHolder.value();
                for (ChemicalStack output : recipe.getOutputDefinition()) {
                    if (!supportedTypes.contains(output.getChemical())) continue;
                    stacks.addAll(recipe.getInput().getRepresentations());
                    continue block1;
                }
            }
        }
        return stacks;
    }

    public static Map<ResourceLocation, BasicItemStackToFluidOptionalItemRecipe> getLiquificationRecipes() {
        HashMap<ResourceLocation, BasicItemStackToFluidOptionalItemRecipe> liquification = new HashMap<ResourceLocation, BasicItemStackToFluidOptionalItemRecipe>();
        for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
            BasicItemStackToFluidOptionalItemRecipe recipe = TileEntityNutritionalLiquifier.getRecipe(((Item)entry.getValue()).getDefaultInstance());
            if (recipe == null) continue;
            liquification.put(RecipeViewerUtils.synthetic(((ResourceKey)entry.getKey()).location(), "liquification", "mekanism"), recipe);
        }
        return liquification;
    }

    public static List<ItemStack> getDisplayItems(ChemicalStackIngredient ingredient) {
        LinkedHashSet tags = new LinkedHashSet();
        for (ChemicalStack chemicalStack : ingredient.getRepresentations()) {
            TagKey<Item> oreTag;
            ChemicalSolidTag tag = chemicalStack.getData(IMekanismDataMapTypes.INSTANCE.chemicalSolidTag());
            if (tag != null) {
                tag.lookupTag().ifPresent(tags::add);
                continue;
            }
            if (chemicalStack.is(MekanismAPITags.Chemicals.DIRTY) || (oreTag = chemicalStack.getChemical().getOreTag()) == null) continue;
            BuiltInRegistries.ITEM.getTag(oreTag).ifPresent(tags::add);
        }
        if (tags.size() == 1) {
            return ((HolderSet.Named)tags.getFirst()).stream().map(ItemStack::new).toList();
        }
        return Collections.emptyList();
    }

    public static Item.TooltipContext getRVTooltipContext() {
        Level level = MekanismClient.tryGetClientWorld();
        if (level == null) {
            return Item.TooltipContext.EMPTY;
        }
        if (Minecraft.getInstance().isSameThread()) {
            return Item.TooltipContext.of((Level)level);
        }
        return Item.TooltipContext.of((HolderLookup.Provider)level.registryAccess());
    }
}

