/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import mekanism.api.IIncrementalEnum;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiHeatTab
extends GuiTexturedElement {
    private static final Map<UnitDisplayUtils.TemperatureUnit, ResourceLocation> ICONS = new EnumMap<UnitDisplayUtils.TemperatureUnit, ResourceLocation>(UnitDisplayUtils.TemperatureUnit.class);
    private final GuiTexturedElement.IInfoHandler infoHandler;
    private List<Component> lastInfo = Collections.emptyList();
    @Nullable
    private Tooltip lastTooltip;

    public GuiHeatTab(IGuiWrapper gui, GuiTexturedElement.IInfoHandler handler) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_TAB, "heat_info.png"), gui, -26, 109, 26, 26);
        this.infoHandler = handler;
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.blit(this.getResource(), this.relativeX, this.relativeY, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        ArrayList<Component> info = new ArrayList<Component>(this.infoHandler.getInfo());
        info.add((Component)MekanismLang.UNIT.translate(MekanismConfig.common.tempUnit.get()));
        if (!info.equals(this.lastInfo)) {
            this.lastInfo = info;
            this.lastTooltip = TooltipUtils.create(info);
        }
        this.setTooltip(this.lastTooltip);
    }

    @Override
    protected ResourceLocation getResource() {
        return ICONS.computeIfAbsent((UnitDisplayUtils.TemperatureUnit)MekanismConfig.common.tempUnit.get(), type -> MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_TAB, "heat_info_" + type.getTabName() + ".png"));
    }

    public void onClick(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.updateTemperatureUnit(IIncrementalEnum::getNext);
        } else if (button == 1) {
            this.updateTemperatureUnit(IIncrementalEnum::getPrevious);
        }
    }

    public boolean isValidClickButton(int button) {
        return button == 0 || button == 1;
    }

    private void updateTemperatureUnit(UnaryOperator<UnitDisplayUtils.TemperatureUnit> converter) {
        UnitDisplayUtils.TemperatureUnit updated;
        UnitDisplayUtils.TemperatureUnit current = (UnitDisplayUtils.TemperatureUnit)MekanismConfig.common.tempUnit.get();
        if (current != (updated = (UnitDisplayUtils.TemperatureUnit)converter.apply(current))) {
            MekanismConfig.common.tempUnit.set(updated);
            MekanismConfig.common.save();
        }
    }
}

