/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import mekanism.api.math.MathUtils;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.graph.GuiLongGraph;
import mekanism.client.gui.element.tab.GuiBoilerTab;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiBoilerStats
extends GuiMekanismTile<TileEntityBoilerCasing, EmptyTileContainer<TileEntityBoilerCasing>> {
    private GuiLongGraph boilGraph;
    private GuiLongGraph maxGraph;

    public GuiBoilerStats(EmptyTileContainer<TileEntityBoilerCasing> container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiBoilerTab((IGuiWrapper)this, (TileEntityBoilerCasing)this.tile, GuiBoilerTab.BoilerTab.MAIN));
        this.addRenderableWidget(new GuiHeatTab(this, () -> {
            Component environment = MekanismUtils.getTemperatureDisplay(((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).lastEnvironmentLoss, UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(environment));
        }));
        this.boilGraph = this.addRenderableWidget(new GuiLongGraph((IGuiWrapper)this, 7, 82, 162, 38, xva$0 -> MekanismLang.BOIL_RATE.translate(xva$0)));
        this.maxGraph = this.addRenderableWidget(new GuiLongGraph((IGuiWrapper)this, 7, 121, 162, 38, xva$0 -> MekanismLang.MAX_BOIL_RATE.translate(xva$0)));
        this.maxGraph.enableFixedScale(MathUtils.clampToLong(MekanismConfig.general.superheatingHeatTransfer.get() * (double)((BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock()).superheatingElements / HeatUtils.getWaterThermalEnthalpy()));
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        BoilerMultiblockData multiblock = (BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock();
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.BOILER_MAX_WATER.translate(TextUtils.format(multiblock.waterTank.getCapacity())), 0, 26, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 8, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.BOILER_MAX_STEAM.translate(TextUtils.format(multiblock.steamTank.getCapacity())), 0, 35, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 8, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.BOILER_HEAT_TRANSFER.translate(), 0, 49, IFancyFontRenderer.TextAlignment.LEFT, this.subheadingTextColor(), 8, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.BOILER_HEATERS.translate(multiblock.superheatingElements), 6, 58, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), this.getXSize() - 6, 8, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.BOILER_CAPACITY.translate(TextUtils.format(multiblock.getBoilCapacity())), 0, 72, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 8, false);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    @Override
    public void containerTick() {
        super.containerTick();
        BoilerMultiblockData multiblock = (BoilerMultiblockData)((TileEntityBoilerCasing)this.tile).getMultiblock();
        this.boilGraph.addData(multiblock.lastBoilRate);
        this.maxGraph.addData(multiblock.lastMaxBoil);
    }
}

