/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.outputs;

import java.util.Objects;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.ItemStackToFluidOptionalItemRecipe;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class OutputHelper {
    private OutputHelper() {
    }

    public static IOutputHandler<@NotNull ChemicalStack> getOutputHandler(final IChemicalTank tank, final CachedRecipe.OperationTracker.RecipeError notEnoughSpaceError) {
        Objects.requireNonNull(tank, "Tank cannot be null.");
        Objects.requireNonNull(notEnoughSpaceError, "Not enough space error cannot be null.");
        return new IOutputHandler<ChemicalStack>(){

            @Override
            public void handleOutput(ChemicalStack toOutput, int operations) {
                OutputHelper.handleOutput(tank, toOutput, operations);
            }

            @Override
            public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, ChemicalStack toOutput) {
                OutputHelper.calculateOperationsCanSupport(tracker, notEnoughSpaceError, tank, toOutput);
            }
        };
    }

    public static IOutputHandler<@NotNull FluidStack> getOutputHandler(final IExtendedFluidTank tank, final CachedRecipe.OperationTracker.RecipeError notEnoughSpaceError) {
        Objects.requireNonNull(tank, "Tank cannot be null.");
        Objects.requireNonNull(notEnoughSpaceError, "Not enough space error cannot be null.");
        return new IOutputHandler<FluidStack>(){

            @Override
            public void handleOutput(FluidStack toOutput, int operations) {
                OutputHelper.handleOutput(tank, toOutput, operations);
            }

            @Override
            public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, FluidStack toOutput) {
                OutputHelper.calculateOperationsCanSupport(tracker, notEnoughSpaceError, tank, toOutput);
            }
        };
    }

    public static IOutputHandler<@NotNull ItemStack> getOutputHandler(final IInventorySlot slot, final CachedRecipe.OperationTracker.RecipeError notEnoughSpaceError) {
        Objects.requireNonNull(slot, "Slot cannot be null.");
        Objects.requireNonNull(notEnoughSpaceError, "Not enough space error cannot be null.");
        return new IOutputHandler<ItemStack>(){

            @Override
            public void handleOutput(ItemStack toOutput, int operations) {
                OutputHelper.handleOutput(slot, toOutput, operations);
            }

            @Override
            public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, ItemStack toOutput) {
                OutputHelper.calculateOperationsCanSupport(tracker, notEnoughSpaceError, slot, toOutput);
            }
        };
    }

    public static IOutputHandler<@NotNull SawmillRecipe.ChanceOutput> getOutputHandler(final IInventorySlot mainSlot, final CachedRecipe.OperationTracker.RecipeError mainSlotNotEnoughSpaceError, final IInventorySlot secondarySlot, final CachedRecipe.OperationTracker.RecipeError secondarySlotNotEnoughSpaceError) {
        Objects.requireNonNull(mainSlot, "Main slot cannot be null.");
        Objects.requireNonNull(secondarySlot, "Secondary/Extra slot cannot be null.");
        Objects.requireNonNull(mainSlotNotEnoughSpaceError, "Main slot not enough space error cannot be null.");
        Objects.requireNonNull(secondarySlotNotEnoughSpaceError, "Secondary/Extra slot not enough space error cannot be null.");
        return new IOutputHandler<SawmillRecipe.ChanceOutput>(){

            @Override
            public void handleOutput(SawmillRecipe.ChanceOutput toOutput, int operations) {
                OutputHelper.handleOutput(mainSlot, toOutput.getMainOutput(), operations);
                ItemStack secondaryOutput = toOutput.getSecondaryOutput();
                for (int i = 0; i < operations; ++i) {
                    OutputHelper.handleOutput(secondarySlot, secondaryOutput, operations);
                    if (i >= operations - 1) continue;
                    secondaryOutput = toOutput.nextSecondaryOutput();
                }
            }

            @Override
            public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, SawmillRecipe.ChanceOutput toOutput) {
                OutputHelper.calculateOperationsCanSupport(tracker, mainSlotNotEnoughSpaceError, mainSlot, toOutput.getMainOutput());
                if (tracker.shouldContinueChecking()) {
                    OutputHelper.calculateOperationsCanSupport(tracker, secondarySlotNotEnoughSpaceError, secondarySlot, toOutput.getMaxSecondaryOutput());
                }
            }
        };
    }

    public static IOutputHandler< @NotNull PressurizedReactionRecipe.PressurizedReactionRecipeOutput> getOutputHandler(final IInventorySlot slot, final CachedRecipe.OperationTracker.RecipeError slotNotEnoughSpaceError, final IChemicalTank tank, final CachedRecipe.OperationTracker.RecipeError tankNotEnoughSpaceError) {
        Objects.requireNonNull(slot, "Slot cannot be null.");
        Objects.requireNonNull(tank, "Tank cannot be null.");
        Objects.requireNonNull(slotNotEnoughSpaceError, "Slot not enough space error cannot be null.");
        Objects.requireNonNull(tankNotEnoughSpaceError, "Tank not enough space error cannot be null.");
        return new IOutputHandler<PressurizedReactionRecipe.PressurizedReactionRecipeOutput>(){

            @Override
            public void handleOutput(PressurizedReactionRecipe.PressurizedReactionRecipeOutput toOutput, int operations) {
                OutputHelper.handleOutput(slot, toOutput.item(), operations);
                OutputHelper.handleOutput(tank, toOutput.chemical(), operations);
            }

            @Override
            public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, PressurizedReactionRecipe.PressurizedReactionRecipeOutput toOutput) {
                OutputHelper.calculateOperationsCanSupport(tracker, slotNotEnoughSpaceError, slot, toOutput.item());
                if (tracker.shouldContinueChecking()) {
                    OutputHelper.calculateOperationsCanSupport(tracker, tankNotEnoughSpaceError, tank, toOutput.chemical());
                }
            }
        };
    }

    public static IOutputHandler< @NotNull ItemStackToFluidOptionalItemRecipe.FluidOptionalItemOutput> getOutputHandler(final IExtendedFluidTank tank, final CachedRecipe.OperationTracker.RecipeError tankNotEnoughSpaceError, final IInventorySlot slot, final CachedRecipe.OperationTracker.RecipeError slotNotEnoughSpaceError) {
        Objects.requireNonNull(tank, "Tank cannot be null.");
        Objects.requireNonNull(slot, "Slot cannot be null.");
        Objects.requireNonNull(tankNotEnoughSpaceError, "Tank not enough space error cannot be null.");
        Objects.requireNonNull(slotNotEnoughSpaceError, "Slot not enough space error cannot be null.");
        return new IOutputHandler<ItemStackToFluidOptionalItemRecipe.FluidOptionalItemOutput>(){

            @Override
            public void handleOutput(ItemStackToFluidOptionalItemRecipe.FluidOptionalItemOutput toOutput, int operations) {
                OutputHelper.handleOutput(tank, toOutput.fluid(), operations);
                OutputHelper.handleOutput(slot, toOutput.optionalItem(), operations);
            }

            @Override
            public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, ItemStackToFluidOptionalItemRecipe.FluidOptionalItemOutput toOutput) {
                OutputHelper.calculateOperationsCanSupport(tracker, tankNotEnoughSpaceError, tank, toOutput.fluid());
                if (tracker.shouldContinueChecking()) {
                    OutputHelper.calculateOperationsCanSupport(tracker, slotNotEnoughSpaceError, slot, toOutput.optionalItem());
                }
            }
        };
    }

    public static IOutputHandler< @NotNull ElectrolysisRecipe.ElectrolysisRecipeOutput> getOutputHandler(final IChemicalTank leftTank, final CachedRecipe.OperationTracker.RecipeError leftNotEnoughSpaceError, final IChemicalTank rightTank, final CachedRecipe.OperationTracker.RecipeError rightNotEnoughSpaceError) {
        Objects.requireNonNull(leftTank, "Left tank cannot be null.");
        Objects.requireNonNull(rightTank, "Right tank cannot be null.");
        Objects.requireNonNull(leftNotEnoughSpaceError, "Left not enough space error cannot be null.");
        Objects.requireNonNull(rightNotEnoughSpaceError, "Right not enough space error cannot be null.");
        return new IOutputHandler<ElectrolysisRecipe.ElectrolysisRecipeOutput>(){

            @Override
            public void handleOutput(ElectrolysisRecipe.ElectrolysisRecipeOutput toOutput, int operations) {
                OutputHelper.handleOutput(leftTank, toOutput.left(), operations);
                OutputHelper.handleOutput(rightTank, toOutput.right(), operations);
            }

            @Override
            public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, ElectrolysisRecipe.ElectrolysisRecipeOutput toOutput) {
                OutputHelper.calculateOperationsCanSupport(tracker, leftNotEnoughSpaceError, leftTank, toOutput.left());
                if (tracker.shouldContinueChecking()) {
                    OutputHelper.calculateOperationsCanSupport(tracker, rightNotEnoughSpaceError, rightTank, toOutput.right());
                }
            }
        };
    }

    private static void handleOutput(IChemicalTank tank, ChemicalStack toOutput, int operations) {
        if (operations == 0) {
            return;
        }
        ChemicalStack output = toOutput.copyWithAmount(toOutput.getAmount() * (long)operations);
        tank.insert(output, Action.EXECUTE, AutomationType.INTERNAL);
    }

    private static void handleOutput(IExtendedFluidTank fluidTank, FluidStack toOutput, int operations) {
        if (operations == 0) {
            return;
        }
        fluidTank.insert(toOutput.copyWithAmount(toOutput.getAmount() * operations), Action.EXECUTE, AutomationType.INTERNAL);
    }

    private static void handleOutput(IInventorySlot inventorySlot, ItemStack toOutput, int operations) {
        if (operations == 0 || toOutput.isEmpty()) {
            return;
        }
        ItemStack output = toOutput.copy();
        if (operations > 1) {
            output.setCount(output.getCount() * operations);
        }
        inventorySlot.insertItem(output, Action.EXECUTE, AutomationType.INTERNAL);
    }

    private static void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, CachedRecipe.OperationTracker.RecipeError notEnoughSpace, IChemicalTank tank, ChemicalStack toOutput) {
        if (!toOutput.isEmpty()) {
            ChemicalStack maxOutput = toOutput.copyWithAmount(Long.MAX_VALUE);
            ChemicalStack remainder = tank.insert(maxOutput, Action.SIMULATE, AutomationType.INTERNAL);
            long amountUsed = maxOutput.getAmount() - remainder.getAmount();
            int operations = MathUtils.clampToInt(amountUsed / toOutput.getAmount());
            tracker.updateOperations(operations);
            if (operations == 0) {
                if (amountUsed == 0L && tank.getNeeded() > 0L) {
                    tracker.addError(CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
                } else {
                    tracker.addError(notEnoughSpace);
                }
            }
        }
    }

    private static void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, CachedRecipe.OperationTracker.RecipeError notEnoughSpace, IExtendedFluidTank tank, FluidStack toOutput) {
        if (!toOutput.isEmpty()) {
            FluidStack maxOutput = toOutput.copyWithAmount(Integer.MAX_VALUE);
            FluidStack remainder = tank.insert(maxOutput, Action.SIMULATE, AutomationType.INTERNAL);
            int amountUsed = maxOutput.getAmount() - remainder.getAmount();
            int operations = amountUsed / toOutput.getAmount();
            tracker.updateOperations(operations);
            if (operations == 0) {
                if (amountUsed == 0 && tank.getNeeded() > 0) {
                    tracker.addError(CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
                } else {
                    tracker.addError(notEnoughSpace);
                }
            }
        }
    }

    private static void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, CachedRecipe.OperationTracker.RecipeError notEnoughSpace, IInventorySlot slot, ItemStack toOutput) {
        if (!toOutput.isEmpty()) {
            ItemStack output = toOutput.copyWithCount(toOutput.getMaxStackSize());
            ItemStack remainder = slot.insertItem(output, Action.SIMULATE, AutomationType.INTERNAL);
            int amountUsed = output.getCount() - remainder.getCount();
            int operations = amountUsed / toOutput.getCount();
            tracker.updateOperations(operations);
            if (operations == 0) {
                if (amountUsed == 0 && slot.getLimit(slot.getStack()) - slot.getCount() > 0) {
                    tracker.addError(CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
                } else {
                    tracker.addError(notEnoughSpace);
                }
            }
        }
    }
}

