/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.chemical;

import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public non-sealed class TagChemicalIngredient
extends ChemicalIngredient {
    public static final MapCodec<TagChemicalIngredient> CODEC = TagKey.codec(MekanismAPI.CHEMICAL_REGISTRY_NAME).xmap(TagChemicalIngredient::new, TagChemicalIngredient::tag).fieldOf("tag");
    private final TagKey<Chemical> tag;

    public TagChemicalIngredient(TagKey<Chemical> tag) {
        this.tag = tag;
    }

    @Override
    public final boolean test(Holder<Chemical> chemical) {
        return chemical.is(this.tag());
    }

    @Override
    public final Stream<Holder<Chemical>> generateChemicalHolders() {
        return MekanismAPI.CHEMICAL_REGISTRY.getTag(this.tag()).stream().flatMap(HolderSet::stream).distinct();
    }

    @Override
    public MapCodec<? extends ChemicalIngredient> codec() {
        return CODEC;
    }

    public final TagKey<Chemical> tag() {
        return this.tag;
    }

    @Override
    public int hashCode() {
        return this.tag.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.tag.equals(((TagChemicalIngredient)obj).tag);
    }
}

