/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.chemical;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.core.Holder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public non-sealed class IntersectionChemicalIngredient
extends ChemicalIngredient {
    public static final MapCodec<IntersectionChemicalIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)IngredientCreatorAccess.chemical().listCodecMultipleElements().fieldOf("children").forGetter(IntersectionChemicalIngredient::children)).apply((Applicative)builder, IntersectionChemicalIngredient::new));
    private final List<ChemicalIngredient> children;

    @ApiStatus.Internal
    public IntersectionChemicalIngredient(List<ChemicalIngredient> children) {
        if (children.size() < 2) {
            throw new IllegalArgumentException("Intersection chemical ingredients require at least two ingredients");
        }
        this.children = children;
    }

    @Override
    public final boolean test(Holder<Chemical> chemical) {
        for (ChemicalIngredient child : this.children) {
            if (child.test(chemical)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Stream<Holder<Chemical>> generateChemicalHolders() {
        return this.children.stream().flatMap(ChemicalIngredient::generateChemicalHolders).distinct().filter(this::test);
    }

    public final List<ChemicalIngredient> children() {
        return this.children;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.children);
    }

    @Override
    public MapCodec<? extends ChemicalIngredient> codec() {
        return CODEC;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.children.equals(((IntersectionChemicalIngredient)obj).children);
    }
}

