/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class BasicCombinerRecipe
extends CombinerRecipe {
    protected final ItemStackIngredient mainInput;
    protected final ItemStackIngredient extraInput;
    protected final ItemStack output;

    public BasicCombinerRecipe(ItemStackIngredient mainInput, ItemStackIngredient extraInput, ItemStack output) {
        this.mainInput = Objects.requireNonNull(mainInput, "Main input cannot be null.");
        this.extraInput = Objects.requireNonNull(extraInput, "Secondary/Extra input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    @Override
    public boolean test(ItemStack input, ItemStack extra) {
        return this.mainInput.test(input) && this.extraInput.test(extra);
    }

    @Override
    public ItemStackIngredient getMainInput() {
        return this.mainInput;
    }

    @Override
    public ItemStackIngredient getExtraInput() {
        return this.extraInput;
    }

    @Override
    @Contract(value="_, _ -> new", pure=true)
    public ItemStack getOutput(@NotNull ItemStack input, @NotNull ItemStack extra) {
        return this.output.copy();
    }

    @Override
    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @Override
    public List<ItemStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    public ItemStack getOutputRaw() {
        return this.output;
    }

    public RecipeSerializer<BasicCombinerRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.COMBINING.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicCombinerRecipe other = (BasicCombinerRecipe)o;
        return this.mainInput.equals(other.mainInput) && this.extraInput.equals(other.extraInput) && ItemStack.matches((ItemStack)this.output, (ItemStack)other.output);
    }

    public int hashCode() {
        int hash = Objects.hash(this.mainInput, this.extraInput);
        hash = 31 * hash + ItemStack.hashItemAndComponents((ItemStack)this.output);
        hash = 31 * hash + this.output.getCount();
        return hash;
    }
}

