/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

@NothingNullByDefault
public class BasicChemicalDissolutionRecipe
extends ChemicalDissolutionRecipe {
    protected final ItemStackIngredient itemInput;
    protected final ChemicalStackIngredient chemicalInput;
    protected final ChemicalStack output;
    private final boolean perTickUsage;

    public BasicChemicalDissolutionRecipe(ItemStackIngredient itemInput, ChemicalStackIngredient chemicalInput, ChemicalStack output, boolean perTickUsage) {
        this.itemInput = Objects.requireNonNull(itemInput, "Item input cannot be null.");
        this.chemicalInput = Objects.requireNonNull(chemicalInput, "Chemical input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
        this.perTickUsage = perTickUsage;
    }

    @Override
    public boolean perTickUsage() {
        return this.perTickUsage;
    }

    @Override
    public ItemStackIngredient getItemInput() {
        return this.itemInput;
    }

    @Override
    public ChemicalStackIngredient getChemicalInput() {
        return this.chemicalInput;
    }

    @Override
    public ChemicalStack getOutput(ItemStack inputItem, ChemicalStack inputChemical) {
        return this.output.copy();
    }

    @Override
    public boolean test(ItemStack itemStack, ChemicalStack chemicalStack) {
        return this.itemInput.test(itemStack) && this.chemicalInput.test(chemicalStack);
    }

    @Override
    public List<ChemicalStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    public ChemicalStack getOutputRaw() {
        return this.output;
    }

    public RecipeSerializer<BasicChemicalDissolutionRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.DISSOLUTION.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicChemicalDissolutionRecipe other = (BasicChemicalDissolutionRecipe)o;
        return this.perTickUsage == other.perTickUsage && this.itemInput.equals(other.itemInput) && this.chemicalInput.equals(other.chemicalInput) && this.output.equals(other.output);
    }

    public int hashCode() {
        return Objects.hash(this.itemInput, this.chemicalInput, this.output, this.perTickUsage);
    }
}

