/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.List;
import java.util.function.BiPredicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.vanilla_input.SingleItemChemicalRecipeInput;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class ItemStackChemicalToObjectRecipe<OUTPUT>
extends MekanismRecipe<SingleItemChemicalRecipeInput>
implements BiPredicate<ItemStack, ChemicalStack> {
    public abstract boolean perTickUsage();

    public abstract ItemStackIngredient getItemInput();

    public abstract ChemicalStackIngredient getChemicalInput();

    @Contract(value="_, _ -> new", pure=true)
    public abstract OUTPUT getOutput(ItemStack var1, ChemicalStack var2);

    @Override
    public abstract boolean test(ItemStack var1, ChemicalStack var2);

    public boolean matches(SingleItemChemicalRecipeInput input, Level level) {
        return !this.isIncomplete() && this.test(input.item(), input.chemical());
    }

    public abstract List<@NotNull OUTPUT> getOutputDefinition();

    @Override
    public boolean isIncomplete() {
        return this.getItemInput().hasNoMatchingInstances() || this.getChemicalInput().hasNoMatchingInstances();
    }
}

