/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datamaps.chemical.attribute;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.datamaps.chemical.attribute.CooledCoolant;
import mekanism.api.datamaps.chemical.attribute.HeatedCoolant;
import mekanism.api.datamaps.chemical.attribute.IChemicalAttribute;
import mekanism.api.math.MathUtils;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ITooltipHelper;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;

public sealed interface IChemicalCoolant
extends IChemicalAttribute
permits CooledCoolant, HeatedCoolant {
    public double thermalEnthalpy();

    public double conductivity();

    public Holder<Chemical> otherVariant();

    @Override
    default public void collectTooltips(Item.TooltipContext context, List<Component> tooltips, TooltipFlag tooltipFlag) {
        ITooltipHelper tooltipHelper = ITooltipHelper.INSTANCE;
        tooltips.add((Component)APILang.CHEMICAL_ATTRIBUTE_COOLANT_EFFICIENCY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getPercent(this.conductivity())));
        tooltips.add((Component)APILang.CHEMICAL_ATTRIBUTE_COOLANT_ENTHALPY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getEnergyPerMBDisplayShort(MathUtils.clampToLong(this.thermalEnthalpy()))));
    }

    public static <COOLANT extends IChemicalCoolant> Products.P3<RecordCodecBuilder.Mu<COOLANT>, Holder<Chemical>, Double, Double> createBaseCodec(RecordCodecBuilder.Instance<COOLANT> instance, String otherFormName, double defaultConductivity) {
        return instance.group((App)ChemicalStack.CHEMICAL_NON_EMPTY_HOLDER_CODEC.fieldOf(otherFormName).forGetter(IChemicalCoolant::otherVariant), (App)Codec.doubleRange((double)Double.MIN_VALUE, (double)Double.MAX_VALUE).fieldOf("thermal_enthalpy").forGetter(IChemicalCoolant::thermalEnthalpy), (App)Codec.doubleRange((double)Double.MIN_VALUE, (double)1.0).optionalFieldOf("conductivity", (Object)defaultConductivity).forGetter(IChemicalCoolant::conductivity));
    }

    public static void validateCoolantParams(Holder<Chemical> otherVariant, double thermalEnthalpy, double conductivity) {
        if (otherVariant.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
            throw new IllegalArgumentException("Coolants can not be made that point to the empty chemical");
        }
        if (thermalEnthalpy <= 0.0) {
            throw new IllegalArgumentException("Coolant attributes must have a thermal enthalpy greater than zero! Thermal Enthalpy: " + thermalEnthalpy);
        }
        if (conductivity <= 0.0 || conductivity > 1.0) {
            throw new IllegalArgumentException("Coolant attributes must have a conductivity greater than zero and at most one! Conductivity: " + conductivity);
        }
    }
}

